//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: P70 is an external event input.
//				  When P70 signals a falling edge, the counter value is incremented by one. 
//				  When the counter value is the same as T00REG and T01REG, the TC01 interrupt occurs.
//				  At this point, P90 output level is inverted. 
//****************************************** 
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6811.h"
void main()
{
	WDCDR.byte = 0x4e;	   //clear WDT
	
  	P7CR.bit.b0 = 0;		//set P70 event clock input
 	P9CR.bit.b0	= 1;		//set P90 output
	
	__asm("DI");
	POFFCR0.byte=0x10; 		//enable TC00 and TC01 
	EIRH.bit.b5	=1; 		//enable TC01 interrupt 
	__asm("EI");
	T01MOD.byte=0xC4;		//<DBE0>=1,<TCK0>=001,<EIN0>=1,<TCM0>=0 8-bit event counter mode
	T001CR.bit.b2 = 1;			//switch to 16-bit mode
	T00REG.byte=0x14;		//set timer value
	T01REG.byte=0x0;		//set timer value
	T001CR.bit.b1=1;		//start 16-bit timer  
    while(1)
	{
	
		WDCDR.byte = 0x4e;	   //clear WDT
	}             
       
    
}